unit IWCompEditWAP;

interface

uses
  {$IFDEF VSNET}
  System.ComponentModel, System.Drawing,
  {$ENDIF}
  Classes, IWControlWAP, IWBaseWAPInterfaces, IWBaseControl, IWBaseRenderContext, IWWapTag,
  IWBaseComponent, IWBaseInterfaces, IWMarkupLanguageTag, IWTypes, IWBaseWapControl,
  IWWAPRenderContext;

type
  TIWCustomEditWAP = class(TIWCustomControlWAP, IIWInputControl)
  private
    FMask: string;
    FMaxLength: Integer;
    FPasswordPrompt: Boolean;
    FRequired: Boolean;
  protected
    procedure SetValue(const AValue: string); virtual;

    procedure InitControl; override;
  public
    function RenderWap(AContext: TIWBaseWapComponentContext): TIWWapTag; override;

    property Mask: string read FMask write FMask;
    property MaxLength: Integer read FMaxLength write FMaxLength;
    property PasswordPrompt: Boolean read FPasswordPrompt write FPasswordPrompt;
    property Required: Boolean read FRequired write FRequired;
  end;

  {$IFDEF VSNET}
  {$R icons\Atozed.Intraweb.TIWEditWAP.bmp}
  TIWEditWAP = class;
  [ToolboxItem(true), ToolboxBitmap(typeof(TIWEditWAP), 'TIWEditWAP.bmp')]
  {$ENDIF}
  TIWEditWAP = class(TIWCustomEditWAP)
  published
    property Mask;
    property MaxLength;
    property PasswordPrompt;
    property Required;
    property Text;
    property Title;
    property TabOrder;
  end;

implementation

uses
  SysUtils;

{ TIWCustomEditWAP }

procedure TIWCustomEditWAP.InitControl;
begin
  inherited;

  Height := 21;
  Width := 121;
end;

function TIWCustomEditWAP.RenderWap(
  AContext: TIWBaseWapComponentContext): TIWWapTag;
begin
  if AContext.PageContext.OutputTagType = wotWML then begin
    //Fix this to allow CreateText
    Result := TIWWAPTag.CreateWAPTag('input', cbSimpleClose);
    try
      Result.AddStringParam('name', Name);
      if Title <> '' then begin
        Result.AddStringParam('title', Title);
      end;
      if FRequired then begin
        Result.AddStringParam('emptyok', 'false');
      end else begin
        Result.AddStringParam('emptyok', 'true');
      end;
      if FPasswordPrompt then begin
        Result.AddStringParam('type', 'password');
      end;
      Result.AddStringParam('value', TextToWML(Text));
      if FMaxLength <> 0 then begin
        Result.AddIntegerParam('maxlength', FMaxLength);
      end;
      if TabOrder <> 0 then begin
        Result.AddIntegerParam('tabindex', TabOrder);
      end;
      if FMask <> '' then begin
        Result.AddStringParam('format', FMask);
      end;
    except
       FreeAndNil(Result);
       raise;
    end;
  end else begin
    Result :=TIWWAPTag.CreateWAPTag('input');                  
    try
      Result.AddStringParam('name', Name);
      Result.AddStringParam('value', TextToWML(Text));

      if FMaxLength <> 0 then begin
        Result.AddIntegerParam('maxlength', FMaxLength);
      end;
      if FPasswordPrompt then begin
        Result.AddStringParam('type', 'password');
      end;
      if TabOrder <> 0 then begin
        Result.AddIntegerParam('tabindex', TabOrder);
      end;
    except
      FreeAndNil(Result);
      raise;
    end;
  end;
end;

procedure TIWCustomEditWAP.SetValue(const AValue: string);
begin
  if RequiresUpdateNotification(Parent) then begin
    UpdateNotifiedInterface(Parent).NotifyUpdate(Self,AValue);
  end;
  Text := AValue;
  Invalidate;
end;

end.
